---
generated_at: 2026-01-21 16:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Rule Files

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00008.sql` (行1-238)
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` (行117-207)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行10)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは8である | E-01（行15: p_id=>8） | ○ |
| C-02 | エイリアスはRULE-FILESである | E-01（行17: p_alias=>'RULE-FILES'） | ○ |
| C-03 | Protection LevelはCである | E-01（行22: p_protection_level=>'C'） | ○ |
| C-04 | モーダルダイアログである | E-01（行18: p_page_mode=>'MODAL'） | ○ |
| C-05 | P8_JSON_FILEはファイルアップロード形式 | E-01（行194: p_display_as=>'NATIVE_FILE'） | ○ |
| C-06 | 許可するファイル形式は.json | E-01（行201: p_attribute_11=>'.json'） | ○ |
| C-07 | 表示スタイルはDROPZONE_BLOCK | E-01（行202: p_attribute_12=>'DROPZONE_BLOCK'） | ○ |
| C-08 | Import/Exportリージョンは折りたたみ式 | E-01（行28, 151: is-collapsed） | ○ |
| C-09 | Import処理はqa_apex_app_pkg.p_upload_rules_jsonを呼び出す | E-01（行229: process_sql_clob） | ○ |
| C-10 | 成功メッセージは「File imported.」 | E-01（行233: p_process_success_message） | ○ |
| C-11 | p_upload_rules_jsonでMIMEタイプを検証 | E-02（行143-146） | ○ |
| C-12 | 無効MIMEタイプのエラーメッセージが定義されている | E-02（行145-146） | ○ |
| C-13 | qa_export_import_rules_pkg.f_import_clob_to_qa_import_filesを呼び出す | E-02（行148-150） | ○ |
| C-14 | qa_export_import_rules_pkg.p_import_clob_to_rules_tableを呼び出す | E-02（行152） | ○ |
| C-15 | Export用レポートはQA_CLIENT_NAMES_P0008_Vを使用 | E-01（行47: p_query_table=>'QA_CLIENT_NAMES_P0008_V'） | ○ |
| C-16 | データなしメッセージは「No rules defined.」 | E-01（行83: p_no_data_found_message=>'No rules defined.'） | ○ |
| C-17 | ダウンロードリンクはgetRuleJSONAttachmentを使用 | E-01（行99: APPLICATION_PROCESS=getRuleJSONAttachment） | ○ |
| C-18 | AutocompleteはOFFに設定 | E-01（行20: p_autocomplete_on_off=>'OFF'） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_CLIENT_NAMES_P0008_Vビューが正しく定義されているか確認
- [ ] Application Process「getRuleJSONAttachment」が定義されているか確認
- [ ] qa_export_import_rules_pkgパッケージが存在し、正しく機能するか確認
- [ ] 大きなJSONファイルのインポート・エクスポートパフォーマンスを確認
- [ ] JSON構造の検証（不正なJSON形式への対応）を確認
- [ ] インポート時の既存ルールとの競合処理を確認
